// 8PKPool.cpp: implementation of the C8PKPool class.
//

#include "stdafx.h"

#include "8PKPool.h"


C8PKPool::C8PKPool()
{
	m_hLogFile = NULL;
	m_pAcptPool = m_pRecvPool = m_pSendPool = NULL;
}

C8PKPool::~C8PKPool()
{
	LogClose();

	if( m_pAcptPool )
		delete m_pAcptPool;

	if( m_pRecvPool )
		delete m_pRecvPool;

	if( m_pSendPool )
		delete m_pSendPool;

	m_pAcptPool = m_pRecvPool = m_pSendPool = NULL;
}

BOOL C8PKPool::Create( char *lpszFileName )
{
	if( lpszFileName )
		LogOpen( lpszFileName );

//-> bug fixed. why needs 64..??
	m_pAcptPool = new C8MemPool <OVERLAPPEDPLUS> ( MAXUSER*2, MAXPACKETSIZE+64 );
//->
	m_pRecvPool = new C8MemPool <OVERLAPPEDPLUS> ( MAXUSER*2, MAXPACKETSIZE );
	m_pSendPool = new C8MemPool <OVERLAPPEDPLUS> ( MAXUSER*2, MAXPACKETSIZE );

	LogWrite( "acpt=%08X, recv=%08X, send=%08X", m_pAcptPool, m_pRecvPool, m_pSendPool );

	if( !m_pAcptPool || !m_pRecvPool || !m_pSendPool )
		return FALSE;

	return TRUE;
}

BOOL C8PKPool::LogOpen( char *lpszFileName )
{
	if( m_hLogFile || lpszFileName == NULL )
	{
		return FALSE;
	}
	
	m_hLogFile = fopen( lpszFileName, "ab" );

	if( !m_hLogFile )
		return FALSE;

	return TRUE;
}

BOOL __cdecl C8PKPool::LogWrite( char *lpszFmt, ... )
{
	va_list		argptr;
	char		szOutStr[1024];
	
	if( NULL == m_hLogFile )
		return FALSE;
	
	va_start(argptr, lpszFmt);
	vsprintf(szOutStr, lpszFmt, argptr);
	va_end(argptr);
	
	int nBytesWritten = fprintf( m_hLogFile, "%s\r\n", szOutStr );
	fflush( m_hLogFile );

	return TRUE;
}

void C8PKPool::LogClose()
{
	if( m_hLogFile )
		fclose( m_hLogFile );

	m_hLogFile = NULL;
}

BOOL C8PKPool::AllocAcptPacket( LPOVERLAPPEDPLUS &newolp )
{
	LPOVERLAPPEDPLUS olp = NULL;
	BOOL bRet = FALSE;

	olp = m_pAcptPool->Alloc();
	LogWrite( "AlocAcptPacket(%08X)", (DWORD)olp );

	if( olp )
	{
		newolp = olp;
		newolp->wbuf.buf = (char*)(olp+1);
		bRet   = TRUE;
	}

	return bRet;
}
BOOL C8PKPool::AllocRecvPacket( LPOVERLAPPEDPLUS &newolp )
{
	LPOVERLAPPEDPLUS olp = NULL;
	BOOL bRet = FALSE;

	olp = m_pRecvPool->Alloc();
	LogWrite( "AlocRecvPacket(%08X)", (DWORD)olp );

	if( olp )
	{
		newolp = olp;
		newolp->wbuf.buf = (char*)(olp+1);
		bRet   = TRUE;
	}

	return bRet;
}
BOOL C8PKPool::AllocSendPacket( LPOVERLAPPEDPLUS &newolp )
{
	LPOVERLAPPEDPLUS olp = NULL;
	BOOL bRet = FALSE;

	olp = m_pSendPool->Alloc();
	LogWrite( "AlocSendPacket(%08X)", (DWORD)olp );

	if( olp )
	{
		newolp = olp;
		newolp->wbuf.buf = (char*)(olp+1);
		bRet   = TRUE;
	}

	return bRet;
}

BOOL C8PKPool::FreeAcptPacket( LPOVERLAPPEDPLUS olp )
{
	LogWrite( "FreeAcptPacket(%08X)", (DWORD)olp );
	return( m_pAcptPool->Free(olp) );
}
BOOL C8PKPool::FreeRecvPacket( LPOVERLAPPEDPLUS olp )
{
	LogWrite( "FreeRecvPacket(%08X)", (DWORD)olp );
	return( m_pRecvPool->Free(olp) );
}
BOOL C8PKPool::FreeSendPacket( LPOVERLAPPEDPLUS olp )
{
	LogWrite( "FreeSendPacket(%08X)", (DWORD)olp );
	return( m_pSendPool->Free(olp) );
}
